Scriptname SKDP_CastLandSpell extends activemagiceffect  
{Adds the land portion of Nereid's spell, which mainly monitors for contact with water}

Spell Property LandSpell Auto 

EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	akTarget.AddSpell(LandSpell,false)
endEVENT
	
EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	akTarget.RemoveSpell(LandSpell)
endEVENT

; Since Nereid's enchantment has several condition functions, and condition functions are not retained when an object is disenchanted for its magic effect,
; 	the solution was to make a "2nd gen" enchantment which casts a spell on the wearer which has the needed condition functions.
;	This script applies that spell.

; The Nereid's enchantment (or spell) has a land effect, which removes clothes on contact with water, and a water effect, which mainly replaces clothes back on shore.  
;	Since the conditions for each are not exact reversals of the other, close but not exact, it required two effects for the spell to work.
; 	The land spell persists on land and water.  It is part of the 1st Gen enchantment, and determines the duration of cast spells.
;     The water spell is applied only when the actor  is in the water, and remains until the actor leaves the water.  

; 1st generation enchantments don't have a land spell.  The enchantment itself is the land spell.  They do have a 1st Gen water spell.

; 2nd generation enchantments will use the 2nd gen land and 2nd gen water spell.
;	Although 1st and 2nd gen functions work about the same, when NPC's replace their clothes and armor, they appear to also dispel constant/self spells --
;	so the land effect disappears after they leave the water.  The 2nd gen water spell simply re-applies it.  The land spell is dispelled when the item is removed.
;	That said, other times that the NPC re-equips itself, it doesn't remove the land effect then, and NPCs continue to strip in contact with water.

; Spells that are fire & forget on targets, like pool party and skinnydip rally, will use something similar to the 2nd Gen land spell, except it casts the 1st Gen Water Spell
;	After putting their clothes back on, NPCs retain fire&forget/target spells, so the land spell does not need to be re-applied upon exiting the water.
;	If it were, there would be no mechanism for removing it, and so it would remain on the actor permanently, or at least for awhile.
